<?php
/**
 *wwww.muservidores.com
 **/

if(!defined('access') or !access) die();
include('inc/template.functions.php');

$disabledSidebar = array(
	'rankings',
);

$serverInfoCache = LoadCacheData('server_info.cache');
if(is_array($serverInfoCache)) {
	$srvInfo = explode("|", $serverInfoCache[1][0]);
}

$maxOnline = config('maximum_online', true);
$onlinePlayers = check_value($srvInfo[3]) ? $srvInfo[3] : 0;
$onlinePlayersPercent = check_value($maxOnline) ? $onlinePlayers*100/$maxOnline : 0;
?>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="utf-8"/>
		<title><?php $handler->websiteTitle(); ?></title>
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="generator" content="WebEngine <?php echo __WEBENGINE_VERSION__; ?>"/>
		<meta name="author" content="Lautaro Angelico"/>
		<meta name="description" content="<?php config('website_meta_description'); ?>"/>
		<meta name="keywords" content="<?php config('website_meta_keywords'); ?>"/>
		<meta property="og:type" content="website" />
		<meta property="og:title" content="<?php $handler->websiteTitle(); ?>" />
		<meta property="og:description" content="<?php config('website_meta_description'); ?>" />
		<meta property="og:image" content="<?php echo __PATH_IMG__; ?>webengine.jpg" />
		<meta property="og:url" content="<?php echo __BASE_URL__; ?>" />
		<meta property="og:site_name" content="<?php $handler->websiteTitle(); ?>" />
		<link rel="shortcut icon" href="<?php echo __PATH_TEMPLATE__; ?>favicon.ico"/>


		<link rel="stylesheet" href="<?php echo __PATH_TEMPLATE_CSS__; ?>dmn.css" type="text/css">
		<link rel="stylesheet" href="<?php echo __PATH_TEMPLATE_CSS__; ?>style.css" type="text/css">
		<link rel="stylesheet" href="<?php echo __PATH_TEMPLATE_CSS__; ?>cmu.css" type="text/css">

		<link rel="stylesheet" href="<?php echo __PATH_TEMPLATE_CSS__; ?>ui.css" type="text/css">
		<link rel="stylesheet" href="<?php echo __PATH_TEMPLATE_CSS__; ?>notice.css" type="text/css">
		<link rel="stylesheet" href="<?php echo __PATH_TEMPLATE_CSS__; ?>validation.css" type="text/css">

		<link rel="stylesheet" href="<?php echo __PATH_TEMPLATE_CSS__; ?>lunatico.css" type="text/css">

		<link rel="stylesheet" href="<?php echo __PATH_TEMPLATE_CSS__; ?>profiles.css" type="text/css">
		
		<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css2" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
		
		<script src="<?php echo __PATH_TEMPLATE_JS__; ?>jquery-1.8.3.min.js"></script>
		<script src="<?php echo __PATH_TEMPLATE_JS__; ?>jquery-ui.min.js"></script>
		
		<script>
			var baseUrl = '<?php echo __BASE_URL__; ?>';
		</script>
	</head>
	
	<body>

<div class="smoke"></div>
<div id="exception"></div>
<div class="wrapper">
<div class="topPanel flex-s-c">
<div class="btn-mobile btn-drop" data-class="topPanel-left">
<span></span>
<span></span>
<span></span>
</div>

<div class="topPanel-left">
<div class="mobile-menu">
<ul>
<li class="menu__item"><a class="menu__link" href="<?php echo __BASE_URL__; ?>" title="News">Noticias</a></li>
<li><a href="<?php echo __BASE_URL__; ?>register" title="Registration">Registro</a></li>
<li><a href="<?php echo __BASE_URL__; ?>downloads" title="Files">Descargas</a></li>
<li><a href="<?php echo __BASE_URL__; ?>rankings" title="Rankings">Rankings</a></li>
<li><a href="<?php echo __BASE_URL__; ?>Info" title="Info">Info</a></li>
<li><a href="<?php echo __BASE_URL__; ?>" title="Guides">Guias</a></li>
<li><a href="<?php echo __BASE_URL__; ?>" title="Support" target="_blank">Soporte</a></li>
<li><a href="<?php echo __BASE_URL__; ?>" title="Vote">Votar</a></li>
</ul>
</div>
<nav class="menu-wrapper">

<?php //templateBuildNavbar(); ?>

<ul class="menu menu-main">
<li class="menu__item"><a class="menu__link" href="<?php echo __BASE_URL__; ?>" title="News">Noticias</a></li>
<li class="menu__item"><a class="menu__link" href="<?php echo __BASE_URL__; ?>register" title="Registration">Registro</a></li>
<li class="menu__item"><a class="menu__link" href="<?php echo __BASE_URL__; ?>downloads" title="Files">Descargas</a></li>
<li class="menu__item"><a class="menu__link" href="<?php echo __BASE_URL__; ?>rankings" title="Rankings">Rankings</a></li>
<li class="menu__item"><a class="menu__link" href="<?php echo __BASE_URL__; ?>info" title="Info">Info</a></li>
<li class="menu__item"><a class="menu__link" href="<?php echo __BASE_URL__; ?>" title="Guides">Guias</a></li>
<li class="menu__item"><a class="menu__link" href="<?php echo __BASE_URL__; ?>" title="Support" target="_blank">Soporte</a></li>
</ul>


</nav>

<div class="langBlock parent_block" style="visibility: hidden;">
<div class="langBlock-active flex-c buttonDrop" data-class="langBlock-dropdown">
<img src="<?php echo __PATH_TEMPLATE_IMG__; ?>english.png" alt="English"> <span></span>
</div>
<ul class="langBlock-dropdown toggled_block" style="display: none;">
<li><a href="<?php echo __BASE_URL__; ?>" title="GB" class="f16"><span class="active flag gb"></span></a></li>
</ul>
</div>
</div>

<?php if(!isLoggedIn()) { ?>
<div class="topPanel-right">
<a href="#enter" class="user-enter open_modal"><i class="icon icon-enter"></i> Ingresar</a>
</div>

<?php } else { ?>

<div class="topPanel-right">
<a href="#" class="user-enter main-item">Panel Usuario</a>

<?php templateBuildUsercp(); ?>

<a href="<?php echo __BASE_URL__; ?>logout" class="user-enter main-item">Salir</a>
</div>
<?php } ?>

</div>
<header class="header flex-s-c">
<div class="hero hero_1"></div>
<div class="logo">
<a href="<?php echo __BASE_URL__; ?>">
<img src="<?php echo __PATH_TEMPLATE_IMG__; ?>logo.png" alt="">
</a>
</div>

<div class="headerInfo">
<div class="headerInfo-title">
UNETE A NUESTRO<br> <span>SERVIDOR</span>
</div>

<div class="headerInfo-text">
Demuestra que eres el mejor , servidor totalmente balanceado...
</div>

<div class="headerInfo-button">
<a href="<?php echo __BASE_URL__; ?>downloads" class="button"><i class="icon icon-battle"></i> Descargas</a>
</div>
</div>

<div class="sparks sparks_2">
<div class="spark_1"></div>
<div class="spark_2"></div>
<div class="spark_3"></div>
<div class="spark_4 spark-big"></div>
<div class="spark_5 spark-big"></div>
</div>
</header>
<div class="main">
<div class="sidebar">
<div class="top">
<div class="tabs tabsBlock">
<ul class="tabs-caption tabs-button">
<li class="active">Jugadores</li><li class="">Clanes</li><li class="">Eventos</li>
</ul>
<div class="tabBlock">
<div class="tabs-content tabContent active">

<div id="top_players">
<table class="sidebar_rank" border="0">
	<tbody><tr>
	<th>#</th>
	<th>Country</th>
	<th>Class</th>
	<th>Name</th>
	<th>Resets</th>
	</tr>

<?php
// Top Level Players
$levelRankingData = LoadCacheData('rankings_resets.cache');
$charactersCountry = loadCache('character_country.cache');
$topLevelLimit = 10;
if(is_array($levelRankingData)) {
    $Character = new Character();
    $topLevel = array_slice($levelRankingData, 0, $topLevelLimit);
        foreach($topLevel as $key => $row) {
            if($key == 0) continue;
            $characterIMG = $Character->GenerateCharacterClassAvatar($row[1],false,false);
            echo '<tr>';
			    echo '<td>'. $key . '</td>';
				echo '<td><img src="'. getCountryFlag($charactersCountry[$row[0]]) .'" width="20px" height="auto"  /></td>';
                echo '<td><img src="'.$characterIMG.'" width="20px" height="auto" class="rounded_corners_image" /></td>';
                echo '<td>'.$row[0].'</td>';
                echo '<td class="text-center">'.$row[2].'</td>';
            echo '</tr>';
        }
}	
?>	
</tbody>
</table>
</div>

<a href="<?php echo __BASE_URL__; ?>rankings" id="switch_top_players_DEFAULT" data-count="10" class="button" style="margin-top: 1rem;">More</a> </div>
<div class="tabs-content tabContent">

<div id="top_guilds">
<table class="sidebar_rank" border="0">
	<tbody><tr>
	<th>#</th>
	<th>Logo</th>
	<th style="text-align:center;">Guild</th>
	<th style="text-align:center;">Score</th>
	</tr>

	
<?php
// Top guilds
$GuildRankingData = LoadCacheData('rankings_guilds.cache');
$topGuildLimit = 10;
if(is_array($GuildRankingData)) {
$topGuild = array_slice($GuildRankingData, 0, $topGuildLimit);

                foreach($topGuild as $key => $row) {
                if($key == 0) continue;
                    echo '<tr>';
					    echo '<td>'. $key . '</td>';
						echo '<td>'.returnGuildLogo($row [3], 20).'</td>';
                        echo '<td>'.guildProfile($row[0]).'</td>';
                        echo '<td>'.number_format($row[2]).'</td>';
                    echo '</tr>';
                }
}

?>
	
</tbody>
</table>
</div>
<a href="<?php echo __BASE_URL__; ?>rankings" id="switch_top_guilds_DEFAULT" data-count="10" class="button" style="margin-top: 1rem;">More</a> 
</div> 
<div class="tabs-content tabContent">
<div id="events">
<?php

#Events

            echo'<div style="width:100%;">';
                    echo '<span id="bloodcastle_name"></span><span style="float:right; display:block;" id="bloodcastle_next"></span><br />';
                    echo '<span class="smalltext" style="color: #ff4800;">Starts In</span><span style="float:right; display:block; color:#ff4800;" class="smalltext" id="bloodcastle"></span>';
            echo'</div>';

            echo'<div style="width:100%;">';
                echo '<span id="devilsquare_name"></span><span style="float:right; display:block;" id="devilsquare_next"></span><br />';
                echo '<span class="smalltext" style="color: #ff4800;">Starts In</span><span style="float:right; display:block; color:#ff4800;" class="smalltext" id="devilsquare"></span>';
            echo'</div>';

            echo'<div style="width:100%;">';
                echo '<span id="chaoscastle_name"></span><span style="float:right; display:block;" id="chaoscastle_next"></span><br />';
                echo '<span class="smalltext" style="color: #ff4800;">Starts In</span><span style="float:right; display:block; color:#ff4800;" class="smalltext" id="chaoscastle"></span>';
            echo'</div>';

            echo'<div style="width:100%;">';
                echo '<span id="dragoninvasion_name"></span><span style="float:right; display:block;" id="dragoninvasion_next"></span><br />';
                echo '<span class="smalltext" style="color: #ff4800;">Starts In</span><span style="float:right; display:block; color:#ff4800;" class="smalltext" id="dragoninvasion"></span>';
            echo'</div>';

            echo'<div style="width:100%;">';
                echo '<span id="goldeninvasion_name"></span><span style="float:right; display:block;" id="goldeninvasion_next"></span><br />';
                echo '<span class="smalltext" style="color: #ff4800;">Starts In</span><span style="float:right; display:block; color:#ff4800;" class="smalltext" id="goldeninvasion"></span>';
            echo'</div>';

            echo'<div style="width:100%;">';
                echo '<span id="skeletonking_name"></span><span style="float:right; display:block;" id="skeletonking_next"></span><br />';
                echo '<span class="smalltext" style="color: #ff4800;">Starts In</span><span style="float:right; display:block; color:#ff4800;" class="smalltext" id="skeletonking"></span>';
            echo'</div>';
 
            echo'<div style="width:100%;">';
                echo '<span id="whitewizard_name"></span><span style="float:right; display:block;" id="whitewizard_next"></span><br />';
                echo '<span class="smalltext" style="color: #ff4800;">Starts In</span><span style="float:right; display:block; color:#ff4800;" class="smalltext" id="whitewizard"></span>';
            echo'</div>';
 
            echo'<div style="width:100%;">';
                echo '<span id="castlesiege_name"></span><span style="float:right; display:block;" id="castlesiege_next"></span><br />';
                echo '<span class="smalltext" style="color: #ff4800;">Starts In</span><span style="float:right; display:block; color:#ff4800;" class="smalltext" id="castlesiege"></span>';
            echo'</div>';
?>
</div>

</div>
</div>
</div>
</div>
<div class="discordBlock">

</div>
</div>

<div class="news">
<div class="servers-containers">
<div class="online">
<div class="online-flex flex-c-c">
<div class="online-block online-block-active">
<?php echo config('server_info_exp', true); ?> <span class="color-green"><?php echo number_format($onlinePlayers + 5); ?></span>
<span class="color-online">Online</span>
</div>
</div>
</div>
</div>
<div class="news-title">
Inicio <span></span>
</div>
<div class="content">
<div id="content">

<?php $handler->loadModule($_REQUEST['page'],$_REQUEST['subpage']); ?>

</div>
</div>
</div>


</div> 



<footer class="footer">
<div class="footerInfo">
<div class="footerInfo-title">
<?php echo langf('footer_copyright', array(config('server_name', true), date("Y"))); ?></div>
<div class="footerInfo-text">
<p><a href="<?php echo __BASE_URL__; ?>tos"><?php echo lang('footer_terms'); ?></a></p>
<p><a href="<?php echo __BASE_URL__; ?>privacy"><?php echo lang('footer_privacy'); ?></a></p>

</div>

<div class="footerInfo-buttons">
<div class="temptime">
<div>
Server Time: <span id="ServerTime"> </span>
<time id="tServerTime">&nbsp;</time> <span id="tServerDate">&nbsp;</span>
</div>
<div>
Local Time: <span id="LocalTime"> </span>
<time id="tLocalTime">&nbsp;</time> <span id="tLocalDate">&nbsp;</span>
</div>
</div>
</div>
</div>
<div class="footerMenu flex">

<ul>
<li><a href="<?php echo __BASE_URL__; ?>news" title="News">Noticias</a></li>
<li><a href="<?php echo __BASE_URL__; ?>register" title="Registration">Registro</a></li>
<li><a href="<?php echo __BASE_URL__; ?>downloads" title="Files">Descargas</a></li>
<li><a href="<?php echo __BASE_URL__; ?>rankings" title="Rankings">Rankings</a></li>
</ul>



</div>

<div class="footerRight">
<div class="socBlock">
<a href="https://www.facebook.com/muservidoresdev" class="fb" target="_blank"></a>
<a href="<?php echo __BASE_URL__; ?>" class="dc"></a>
<a href="<?php echo __BASE_URL__; ?>" class="yt"></a>
</div>

</div>
</footer>
</div>


<?php if(!isLoggedIn()) { ?>
<div id="enter" class="modal_div">
<span class="modal_close"></span>
<div class="modalContent">
<div class="modal-title flex-s-c">
<span><?php echo lang('module_titles_txt_2'); ?></span>
<a href="<?php echo __BASE_URL__; ?>register" class="button button-white button-small">Registro</a>
</div>
<form id="login_form" method="POST" action="<?php echo __BASE_URL__ . 'login'; ?>">
<div class="formGroup">
<p>Usuario</p>
<input type="text" name="webengineLogin_user" id="loginBox1" placeholder="username" required="">
</div>
<div class="formGroup">
<p>Contraseña</p>
<input type="password" name="webengineLogin_pwd" id="loginBox2" placeholder="password" required="">
</div>
<div class="formButtons">
<button name="webengineLogin_submit" type="sumbit" value="submit" style="display: block; margin: 0 auto;"><?php echo lang('login_txt_3'); ?></button>
<a class="lost-pass" href="<?php echo __BASE_URL__; ?>" style="display: block;text-align:center;margin-top:1rem;">Recuperar Contraseña?</a>
</div>
</form>
</div>
</div>
<div id="overlay"></div>
<?php } ?>


<script src="<?php echo __PATH_TEMPLATE_JS__; ?>jed.js"></script>
<script src="<?php echo __PATH_TEMPLATE_JS__; ?>jquery.leanModal.min.js"></script>
<script src="<?php echo __PATH_TEMPLATE_JS__; ?>jquery.tooltip.js"></script>
<script src="<?php echo __PATH_TEMPLATE_JS__; ?>ejs.js"></script>
<script src="<?php echo __PATH_TEMPLATE_JS__; ?>helpers.js"></script>
<script src="<?php echo __PATH_TEMPLATE_JS__; ?>app.js"></script>
<script src="<?php echo __PATH_TEMPLATE_JS__; ?>global.js"></script>

<script src="<?php echo __PATH_TEMPLATE_JS__; ?>main.js"></script>

<script type="text/javascript">
    var DmNConfig = {
        base_url: '<?php echo __BASE_URL__; ?>',
        tmp_dir: 'ice',
        currenttime: 'Sep 09, 2021 06:57:30',
        ajax_page_load: 0,
		timers: [
		]    
		};


</script>
	<script src="<?php echo __PATH_TEMPLATE_JS__; ?>jquery.validationEngine-en.js" type="text/javascript"></script>
	<script src="<?php echo __PATH_TEMPLATE_JS__; ?>jquery.validationEngine.js" type="text/javascript"></script>

	<script src="<?php echo __PATH_TEMPLATE_JS__; ?>events.js"></script>
		
<div id="lean_overlay"></div>
</body>
</html>